
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new sample data for tourism locations
np.random.seed(0)

# Generate sample data for three tourist locations
x1 = np.random.normal(-1.5, 1, 100)  # Beach Day
y1 = np.random.normal(3, 1, 100)

x2 = np.random.normal(-2, 1, 100)  # Mountain Hiking
y2 = np.random.normal(-2, 1, 100)

x3 = np.random.normal(2, 1, 100)  # City Tour
y3 = np.random.normal(0, 1, 100)

# Textual content for the new chart
xlabel = "Latitude"
ylabel = "Longitude"
title = "Tourist Locations Distribution"
suptitle = "Analysis of Tourism Trends"
legendlabels = ["Beach Day", "Mountain Hiking", "City Tour"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to 8x8 for clear visibility
plt.figure(figsize=(8, 8))

# Plot the data with customized markers and colors
plt.scatter(x1, y1, c="#FFD700", marker="o", label=legendlabels[0])  # Sandy Yellow
plt.scatter(x2, y2, c="#228B22", marker="^", label=legendlabels[1])  # Forest Green
plt.scatter(x3, y3, c="#708090", marker="s", label=legendlabels[2])  # Urban Gray

# Set the title and labels
plt.title(title, fontsize=16)
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.suptitle(suptitle, fontsize=18)

# Add the legend with a clear position
plt.legend(loc="upper right", frameon=True)

# Adding grid lines for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

# Show the plot with tight layout to minimize white space
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save the plot to a PDF file with the specified name
plt.savefig("scatter_42.pdf", bbox_inches="tight")
