
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting seed for reproducibility
np.random.seed(42)

# Generate sample data for three economic sectors
x_technology = np.random.normal(10, 2, 100)
y_technology = np.random.normal(55, 5, 100)

x_finance = np.random.normal(55, 5, 100)
y_finance = np.random.normal(50, 15, 100)

x_healthcare = np.random.normal(30, 4, 100)
y_healthcare = np.random.normal(65, 2, 100)

# Labels for sectors
labels = ["Technology", "Finance", "Healthcare"]

# Chart text labels
xlabel = 'Time (months)'
ylabel = 'Index Value'
title = 'Economic Indicators Distribution'
legend_labels = ["Technology Sector", "Finance Sector", "Healthcare Sector"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to be comprehensive
plt.figure(figsize=(10, 6))

# Plot the data with different colors and markers
plt.scatter(x_technology, y_technology, c="#ff7f0e", label=labels[0], marker='o')
plt.scatter(x_finance, y_finance, c="#1f77b4", label=labels[1], marker='s')
plt.scatter(x_healthcare, y_healthcare, c="#2ca02c", label=labels[2], marker='^')

# Add the legend with clear labels
plt.legend(legend_labels, loc="upper left", frameon=True)

# Add axis labels and a title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add gridlines for readability
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_43.pdf", bbox_inches="tight")
