# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for media houses, their number of articles, and average ratings.
media_houses = ["MediaA", "MediaB", "MediaC", "MediaD", "MediaE", "MediaF"]
articles = [50, 150, 300, 200, 500, 800]  # Number of articles published.
ratings = [4.5, 3.8, 4.1, 4.0, 4.1, 3.6]  # Average reader ratings.
xlabel = "Number of articles published"  # X-axis label for number of articles.
ylabel = "Average reader rating"  # Y-axis label for ratings.
title = "Articles vs. Reader Ratings of Media Houses"  # Title of the plot.
legendtitle = "Media Houses"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a subplot with a specific size.
fig, ax = plt.subplots(figsize=(8, 5))

# New color palette
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

# Scatter plot each media house's data point and add text annotation.
for i in range(len(media_houses)):
    ax.scatter(
        articles[i],
        ratings[i],
        color=colors[i],
        s=100,
        label=media_houses[i],
        edgecolor="black",
    )  # Plot data points with specific color and edge color.
    # Align text annotations based on position for better readability.
    ax.text(
        articles[i] + 10,
        ratings[i],
        media_houses[i],
        fontsize=10,
        ha="left",
        va="center",
        weight="bold",
    )

# Add a horizontal and a vertical dashed reference line.
ax.axhline(
    y=np.mean(ratings), color="gray", linestyle="--", linewidth=1
)  # Horizontal line at mean rating
ax.axvline(
    x=np.mean(articles), color="gray", linestyle="--", linewidth=1
)  # Vertical line at mean number of articles

# Set the scales of the axes to logarithmic.
ax.set_xscale("log")
ax.set_yscale("linear")

# Set the labels for the axes.
ax.set_xlabel(xlabel)  # X-axis label for number of articles.
ax.set_ylabel(ylabel)  # Y-axis label for ratings.

# Set the title of the plot.
ax.set_title(title)  # Title of the plot.

# Adjust the tick labels.
ax.set_xticks([30, 50, 100, 200, 500, 1000])
ax.get_xaxis().set_major_formatter(plt.ScalarFormatter())
ax.set_yticks([3.5, 4.0, 4.5, 5.0])
ax.get_yaxis().set_major_formatter(plt.ScalarFormatter())

# Add a legend
ax.legend(title=legendtitle)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to ensure all elements fit within the figure area.
plt.tight_layout()
plt.savefig("scatter_44.pdf", bbox_inches="tight")
