
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for various countries, their GDP, and Unemployment rates.
countries = ["USA", "China", "Germany", "Japan", "India", "Brazil"]
gdp = [21, 14, 4, 5, 2.9, 1.8]  # GDP in trillions
unemployment = [5.3, 3.6, 3.3, 2.8, 8.2, 12.1]  # Unemployment Rate (%)
xlabel = "GDP (in trillions)"  # X-axis label for GDP.
ylabel = "Unemployment Rate (%)"  # Y-axis label for Unemployment Rate.
title = "GDP vs. Unemployment Rate in Different Countries"  # Title of the plot.

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a subplot with a specific size.
fig, ax = plt.subplots(figsize=(8, 5))

colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

# Scatter plot each country's data point and add text annotation.
for i in range(len(countries)):
    ax.scatter(
        gdp[i], unemployment[i], color=colors[i], s=100, label=countries[i]
    )  # Plot data points with specific color and size.
    # Align text annotations based on position for better readability.
    ax.text(
        gdp[i] + 0.1, unemployment[i] + 0.1, countries[i], fontsize=10, ha="left", va="bottom"
    )

# Add a horizontal and a vertical dashed reference line.
ax.axhline(
    y=5.0, color="gray", linestyle="--", linewidth=1
)  # Horizontal line at Unemployment Rate=5.0%
ax.axvline(
    x=3.0, color="gray", linestyle="--", linewidth=1
)  # Vertical line at GDP=3.0 trillion

# Use standard scales for the axes.
ax.set_xscale("linear")
ax.set_yscale("linear")

# Set the labels for the axes.
ax.set_xlabel(xlabel)  # X-axis label for GDP.
ax.set_ylabel(ylabel)  # Y-axis label for Unemployment Rate.

# Set the title of the plot.
ax.set_title(title)  # Title of the plot.

# Adding grid for better readability.
ax.grid(True, which="both", linestyle='--', linewidth=0.5)

# Add Legend to explain the data points.
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to ensure all elements fit within the figure area.
plt.tight_layout()
plt.savefig("scatter_46.pdf", bbox_inches="tight")
