# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Random seed for reproducibility
import numpy as np

np.random.seed(42)

# Data for Energy Efficiency plot
efficiency_x = [0.88, 0.82, 0.92, 0.72, 0.96]
efficiency_y = np.random.uniform(50, 100, 5)
efficiency_labels = ["Method A", "Method B", "Method C", "Method D", "Method E"]

# Data for Energy Savings plot
savings_x = [0.88, 0.62, 0.86, 0.89, 0.92]
savings_y = np.random.uniform(20, 70, 5)
savings_labels = [
    "Implementation A",
    "Implementation B",
    "Implementation C",
    "Implementation D",
    "Implementation E",
]

# Extracted variables for plot configuration
efficiency_title = "Energy Efficiency"
efficiency_xlabel = "Efficiency Ratio"
efficiency_ylabel = "Energy Consumption (kWh)"
efficiency_xlim = (0.6, 1.1)
efficiency_xticks = [0.6, 0.7, 0.8, 0.9, 1.0, 1.1]
efficiency_ylim = (45, 105)
efficiency_yticks = [50, 60, 70, 80, 90, 100]

savings_title = "Energy Savings"
savings_xlabel = "Efficiency Ratio"
savings_ylabel = "Energy Savings (kWh)"
savings_xlim = (0.5, 1.0)
savings_xticks = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
savings_ylim = (15, 75)
savings_yticks = [20, 30, 40, 50, 60, 70]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

efficiency_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
savings_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Energy Efficiency plot
for x, y, color, label in zip(
    efficiency_x, efficiency_y, efficiency_colors, efficiency_labels
):
    if label == "Method A":
        ax1.scatter(
            x, y, label=label, facecolors="none", edgecolors=color, s=200, linewidths=4
        )
    else:
        ax1.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax1.set_title(efficiency_title)
ax1.set_xlabel(efficiency_xlabel)
ax1.set_ylabel(efficiency_ylabel)
ax1.set_xlim(efficiency_xlim)  # Adjust x-axis range
ax1.set_xticks(efficiency_xticks)
ax1.set_ylim(efficiency_ylim)  # Adjust y-axis range
ax1.set_yticks(efficiency_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

# Energy Savings plot
for x, y, color, label in zip(savings_x, savings_y, savings_colors, savings_labels):
    if label == "Implementation A":
        ax2.scatter(
            x, y, label=label, facecolors="none", edgecolors=color, s=200, linewidths=4
        )
    else:
        ax2.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax2.set_title(savings_title)
ax2.set_xlabel(savings_xlabel)
ax2.set_ylabel(savings_ylabel)
ax2.set_xlim(savings_xlim)  # Adjust x-axis range
ax2.set_xticks(savings_xticks)
ax2.set_ylim(savings_ylim)  # Adjust y-axis range
ax2.set_yticks(savings_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Method A / Implementation A",
        markersize=10,
        markerfacecolor="none",
        markeredgewidth=4,
        markeredgecolor="#1f77b4",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Method B / Implementation B",
        markersize=10,
        markerfacecolor="#ff7f0e",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Method C / Implementation C",
        markersize=10,
        markerfacecolor="#2ca02c",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Method D / Implementation D",
        markersize=10,
        markerfacecolor="#d62728",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Method E / Implementation E",
        markersize=10,
        markerfacecolor="#9467bd",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=3,
    borderaxespad=0.05,
    frameon=False,
    bbox_to_anchor=(0.5, -0.05),
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_52.pdf", bbox_inches="tight")
