
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points
research_hours = [100, 500, 1000, 1500, 2000, 2500]
efficiency = [10, 15, 20, 25, 30, 35]
labels = [None, "Solar", None, "Wind", "Hydro", "Geothermal"]
dashed_lines = [(100, 10, 500, 15), (2000, 30, 2500, 35)]

title = "Renewable Energy Research Efficiency"
xlabel = "Research Hours"
ylabel = "Efficiency Improvement [%]"
texts = ["+5%", "Baseline", "Geothermal", "Conclusion"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(8, 5))
plt.scatter(research_hours, efficiency, color="darkgreen", s=100, marker='o')  # Adjusted marker shape and color

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (research_hours[i], efficiency[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([100, 500], [10, 15], linestyle="--", color="blue", linewidth=1.5)
plt.annotate(texts[0], (300, 12.5), color="blue")
plt.plot([1000, 1500], [20, 25], linestyle="--", color="red", linewidth=1.5)
plt.annotate(texts[1], (1250, 22.5), color="red")
plt.plot([2000, 2500], [30, 35], linestyle="--", color="orange", linewidth=1.5)
plt.annotate(
    texts[2],
    (2250, 32.5),
    color="orange",
    textcoords="offset points",
    xytext=(0, 10),
    ha="center",
)

# Annotating the dashed lines correctly
plt.annotate(texts[3], (2500, 33), color="orange")

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(5, 40)
plt.yticks([10, 15, 20, 25, 30, 35])
plt.xlim(0, 3000)
plt.xticks([0, 500, 1000, 1500, 2000, 2500, 3000])
plt.grid(True)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_53.pdf", bbox_inches="tight")
