
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data points
training_hours = [50, 100, 150, 200, 250, 300]
race_times = [240, 220, 210, 200, 195, 190]  # times in minutes
labels = [None, "Amateur", None, "Semi-Pro", "Pro", "Elite"]
dashed_lines = [(50, 240, 100, 220), (200, 200, 300, 190)]

title = "Marathon Race Performance"
xlabel = "Training Hours"
ylabel = "Race Completion Time [minutes]"
texts = ["-20 minutes", "Trends", "Elite Improvement", "-10 minutes"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(8, 5))
plt.scatter(training_hours, race_times, color="blue", s=100, marker='o')  # Adjusted marker size and color

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (training_hours[i], race_times[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([50, 100], [240, 220], linestyle="--", color="red")
plt.annotate(texts[0], (75, 230), color="red")
plt.plot([200, 300], [200, 190], linestyle="--", color="green")
plt.annotate(texts[1], (215, 195), color="green")
plt.plot([50, 150], [240, 210], linestyle="--", color="purple")
plt.annotate(texts[2], (120, 220), color="purple")

# Annotating the dashed lines correctly
plt.annotate(texts[3], (260, 195), color="green")

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(180, 250)
plt.yticks([190, 200, 210, 220, 230, 240])
plt.xlim(0, 350)
plt.xticks([50, 100, 150, 200, 250, 300])
plt.grid(True)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_55.pdf", bbox_inches="tight")
