# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import matplotlib.ticker as ticker
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
players = ["Player A", "Player B", "Player C", "Player D", "Player E", "Player F"]
performance_time = [15, 30, 45, 60, 75, 90]
average_scores = [7.8, 8.2, 7.5, 8.0, 7.1, 8.5]
sizes = [200, 400, 600, 800, 1000, 1200]

# Plot and legend labels
scatter_label = "Bubble Size: Number of Games Played"

# Axis limits
xlim_values = None  # Not explicitly set in the code
ylim_values = (6.5, 9.0)

# Axis labels
xlabel_value = "Performance Time (minutes)"
ylabel_value = "Average Score"

# Axis ticks
xticks_values = performance_time  # Set by FixedLocator
yticks_values = None  # Not explicitly set in the code

# Axis ticks labels
xtickslabel_values = None  # Not explicitly set in the code
ytickslabel_values = None  # Not explicitly set in the code

# Title
title_value = "Player Performance Analysis"

# Horizontal and vertical lines
axhline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
scatter = ax.scatter(
    performance_time,
    average_scores,
    s=sizes,
    c=colors,
    alpha=0.6,
    edgecolors="w",
    label=scatter_label,
    linewidth=2,
)

# Add labels for each bubble
for i, txt in enumerate(players):
    ax.annotate(
        txt,
        (performance_time[i], average_scores[i]),
        ha="center",
        va="center",
        fontsize=10,
    )

# Set the x-axis to a logarithmic scale
ax.set_xscale("log")
ax.xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x):d}"))
ax.xaxis.set_major_locator(ticker.FixedLocator(performance_time))

# Set axis labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_ylim(ylim_values)

# Add grid
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Set background color to white
fig.patch.set_facecolor("white")
ax.set_facecolor("white")

# Add a title
plt.title(title_value, fontsize=14, fontweight="bold")

# Add legend
legend = ax.legend()

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_57.pdf", bbox_inches="tight")
