# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
names = [
    "5G",
    "4G LTE",
    "WiFi 6",
    "WiFi 5",
    "Bluetooth 5",
    "Bluetooth 4",
    "LoRaWAN",
    "Zigbee",
    "NFC",
]
x = [10, 8, 9, 7, 6, 5, 3, 2, 1]
y = [1, 2, 3, 4, 4, 5, 7, 8, 9]
sizes = [500, 400, 300, 250, 100, 80, 50, 30, 10]
xlabel = "Data Rate (Gbps)"
ylabel = "Latency (ms)"
legend_sizes = [10, 100, 300, 500]
legend_labels = ["10 Mbps", "100 Mbps", "300 Mbps", "500 Mbps"]
legend_title = "Technology Range"
title = "Performance of Communication Technologies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(8, 6))
colors = [
    "#2E8B57",
    "#DAA520",
    "#4682B4",
    "#FF6347",
    "#8A2BE2",
    "#D2691E",
    "#FF4500",
    "#008080",
    "#1E90FF",
]
scatter = ax.scatter(x, y, s=sizes, c=colors, alpha=0.6, edgecolor="w", linewidth=0.5)

# Add annotations
for i, name in enumerate(names):
    ax.annotate(
        name,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=8,
        color=colors[i],
    )

# Customize the axes
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlim(0, 12)
ax.set_ylim(0, 10)

# Add legend for bubble sizes
for size, label in zip(legend_sizes, legend_labels):
    ax.scatter(
        [], [], c="grey", alpha=0.6, s=size, label=label, edgecolor="w", linewidth=0.5
    )

# Adjust the legend to have increased spacing
ax.legend(
    scatterpoints=1,
    frameon=False,
    labelspacing=2,
    handletextpad=2,
    columnspacing=6,
    title=legend_title,
    fontsize=9,
    loc="upper right",
    bbox_to_anchor=(1.3, 1),
    ncol=1,
)

plt.grid(True, linestyle="--", linewidth=0.5)
plt.title(title, fontsize=14, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_59.pdf", bbox_inches="tight")
