# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
names = [
    "5G Network",
    "Blockchain",
    "Quantum Computing",
    "AI in Healthcare",
    "IoT",
    "AR/VR",
    "Autonomous Vehicles",
    "Renewable Energy",
    "Cybersecurity",
]
x = [30, 40, 35, 50, 45, 25, 35, 40, 50]
y = [60, 55, 70, 35, 50, 45, 75, 60, 65]
sizes = [1000, 1500, 2000, 2500, 1800, 1300, 1700, 2200, 1600]
xlabel = "Adoption Rate (in %)"
ylabel = "Satisfaction Rate (in %)"
legend_sizes = [1000, 1500, 2000, 2500, 3000]
legend_labels = ["1B", "1.5B", "2B", "2.5B", ">3B"]
legend_title = "Investment in Billion USD"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 8))
colors = [
    "green",
    "purple",
    "orange",
    "blue",
    "brown",
    "pink",
    "red",
    "cyan",
    "magenta",
]
scatter = ax.scatter(x, y, s=sizes, c=colors, alpha=0.6, edgecolors="w", linewidth=0.5)

# Add annotations
for i, name in enumerate(names):
    ax.annotate(
        name,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
        color="darkblue",
    )

# Customize the axes
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlim(20, 55)
ax.set_ylim(40, 80)

# Add legend for bubble sizes
for size, label in zip(legend_sizes, legend_labels):
    ax.scatter([], [], c="grey", alpha=0.3, s=size, label=label)

# Adjust the legend to have increased spacing
legend = ax.legend(
    scatterpoints=1,
    frameon=False,
    labelspacing=1.5,
    handletextpad=1,
    columnspacing=2,
    title=legend_title,
    fontsize=10,
    loc="upper center",
    bbox_to_anchor=(0.5, 1.15),
    ncol=len(legend_sizes),
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

plt.grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_61.pdf", bbox_inches="tight")
