# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
year_index = [2010, 2012, 2014, 2016, 2018]
group_a_growth = [2.5, 3.0, 3.4, 3.1, 3.6]  # Percentage growth
group_b_growth = [1.8, 2.1, 2.5, 2.7, 2.9]
group_c_growth = [0.5, 0.7, 0.8, 0.6, 0.9]

# Labels and Titles
xlabel = "Year"
ylabel = "Growth Rate (%)"
title = "Growth Rate of Different Religious Groups Over Time"

# Legend labels
group_a_label = "Group A"
group_b_label = "Group B"
group_c_label = "Group C"

# Plot limits
xlim_values = (2009, 2019)
ylim_values = (0.0, 4.0)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size in inches
plt.figure(figsize=(10, 7))

# Plotting the data with adjusted marker sizes
plt.scatter(
    year_index,
    group_a_growth,
    label=group_a_label,
    color="#1f77b4",  # blue
    clip_on=False,
    zorder=10,
    marker="^",
    s=200,
)  # Adjusted marker size
plt.scatter(
    year_index,
    group_b_growth,
    label=group_b_label,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",  # orange
    marker="s",
    s=200,
)  # Adjusted marker size
plt.scatter(
    year_index,
    group_c_growth,
    label=group_c_label,
    clip_on=False,
    zorder=10,
    color="#2ca02c",  # green
    marker="o",
    s=150,
)  # Adjusted marker size

# Adding labels and title
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16, y=1.1)

# Adding a legend with adjusted order and customization
handles, labels = plt.gca().get_legend_handles_labels()
order = [2, 1, 0]  # Adjusted order to match the reference picture
legend = plt.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper left",
    ncol=1,
    frameon=True,
)
for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
# Show grid with custom settings
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_62.pdf", bbox_inches="tight")
