# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Bicycle",
    "Bus",
    "Car",
    "Train",
    "Airplane",
    "Boat",
    "Tram",
    "Motorcycle",
]
efficiency = [0.5, 0.65, 0.65, 0.80, 0.85, 0.60, 0.70, 0.55]
safety = [0.6, 0.75, 0.6, 0.9, 0.95, 0.7, 0.75, 0.65]
xlabel = "Transportation Modes"
ylabel = "Performance Metrics"
labels = ["Efficiency", "Safety"]
title = "Efficiency and Safety Metrics for Various Transportation Modes (2023)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(8, 4))

# Plotting data with different colors and marker styles
plt.scatter(categories, efficiency, color="#1f77b4", marker="o", s=100, label=labels[0])
plt.scatter(categories, safety, color="#ff7f0e", marker="s", s=100, label=labels[1])

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding grid with custom style
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=45)
plt.ylim(0, 1)

# Adjusting legend placement
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("scatter_66.pdf", bbox_inches="tight")
