# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
categories = [
    "Christianity",
    "Islam",
    "Hinduism",
    "Buddhism",
    "Sikhism",
    "Judaism",
    "Baha'i",
    "Jainism",
]
majority_accuracy = [0.85, 0.78, 0.65, 0.60, 0.55, 0.50, 0.45, 0.40]
minority_accuracy = [0.20, 0.30, 0.40, 0.45, 0.50, 0.55, 0.60, 0.65]
xlabel = "Religions"
ylabel = "Representation Accuracy"
labels = ["Majority Group", "Minority Group"]
title = "Representation Accuracy for Various Religions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(7, 4))

# Plotting the data with custom colors and markers
plt.scatter(categories, majority_accuracy, color="#377eb8", marker="o", label=labels[0])
plt.scatter(categories, minority_accuracy, color="#ff7f00", marker="s", label=labels[1])

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding grid
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=45)
plt.ylim(0, 1)

# Adjusting legend placement to match the reference picture
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to match the reference picture
plt.tight_layout()
plt.savefig("scatter_67.pdf", bbox_inches="tight")
