# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Data for the plots
names = [
    "Lectures",
    "Online Courses",
    "Workshops",
    "Seminars",
    "Textbooks",
    "Interactive",
    "Projects",
]
x1 = [1500, 800, 1000, 600, 400, 1200, 1000]
y1 = [75, 80, 70, 65, 60, 85, 90]

x2 = [3000, 2000, 2500, 1500, 1000, 3500, 3000]
y2 = [75, 80, 70, 65, 60, 85, 90]

titles = [
    "Teaching Methods (Effectiveness versus Cost)",
    "Teaching Methods (Effectiveness versus Time Invested in Hours)",
]
xlabels = ["Cost (in $)", "Time Invested (in Hours)"]
ylabels = ["Effectiveness (%)", "Effectiveness (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))


# Define colors (pastel shades)
colors1 = ["#FFB6C1", "#ADD8E6", "#98FB98", "#FFD700", "#87CEFA", "#FF69B4", "#FFA07A"]
colors2 = ["#FFB6C1", "#ADD8E6", "#98FB98", "#FFD700", "#87CEFA", "#FF69B4", "#FFA07A"]

# First subplot
ax1.scatter(x1, y1, c=colors1, marker="o", edgecolor="black", s=100)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.invert_xaxis()  # Invert x-axis
for i, txt in enumerate(names):
    ax1.annotate(
        txt, (x1[i], y1[i]), xytext=(-10, 5), textcoords="offset points", fontsize=10
    )
ax1.set_xlim([1600, 0])
ax1.set_ylim([55, 95])

# Second subplot
ax2.scatter(x2, y2, c=colors2, marker="s", edgecolor="black", s=100)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.ticklabel_format(style="sci", axis="x", scilimits=(0, 0))  # Use scientific notation
for i, txt in enumerate(names):
    ax2.annotate(
        txt, (x2[i], y2[i]), xytext=(-15, 5), textcoords="offset points", fontsize=10
    )
ax2.set_xlim([4000, 0])
ax2.set_ylim([55, 95])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_69.pdf", bbox_inches="tight")
