
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plots
attraction_types = ["Museums", "Parks", "Beaches", "Historical Sites", "Amusement Parks", "Shopping Centers", "Zoos"]
visitor_numbers = [10, 25, 40, 20, 15, 30, 12]  # in millions
satisfaction_ratings = [85, 90, 88, 80, 75, 70, 65]  # out of 100

investment_cost = [5e7, 2.5e7, 4e7, 3e7, 2e7, 4.5e7, 3.5e7]  # in dollars
annual_visits = [10, 25, 40, 20, 15, 30, 12]  # in millions

titles = [
    "Tourist Attractions (Satisfaction vs Visitor Numbers)",
    "Tourist Attractions (Satisfaction vs Investment Cost)",
]
xlabels = ["Visitor Numbers (millions)", "Investment Cost (millions $)"]
ylabels = ["Average Satisfaction (out of 100)", "Average Satisfaction (out of 100)"]
legendlabels = ["Types of Attractions"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 6))

colors = ["#4e79a7", "#f28e2c", "#e15759", "#76b7b2", "#59a14f", "#edc949", "#af7aa1"]
markers = ["o", "s", "D", "^", "v", "<", ">"]

# First subplot
for i, txt in enumerate(attraction_types):
    ax1.scatter(visitor_numbers[i], satisfaction_ratings[i], color=colors[i], marker=markers[i], s=100, label=txt)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.set_xlim([0, 50])
ax1.set_ylim([60, 100])
ax1.grid(True)
ax1.legend(loc='best')

# Second subplot
for i, txt in enumerate(attraction_types):
    ax2.scatter(investment_cost[i], satisfaction_ratings[i], color=colors[i], marker=markers[i], s=100, label=txt)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.ticklabel_format(style="sci", axis="x", scilimits=(0, 0))  # Use scientific notation
ax2.set_xlim([0, 5.5e7])
ax2.set_ylim([60, 100])
ax2.grid(True)
ax2.legend(loc='best')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_70.pdf", bbox_inches="tight")
