# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
engagement_rate = [
    3.5,
    4.0,
    2.5,
    5.5,
    3.0,
    6.0,
    2.0,
    4.5,
]  # Engagement rate percentages on different social media platforms
follower_growth = [
    12,
    15,
    8,
    17,
    13,
    20,
    7,
    18,
]  # Corresponding follower growth percentages
social_media_platforms = [
    "Facebook",
    "Instagram",
    "Twitter",
    "LinkedIn",
    "Snapchat",
    "TikTok",
    "Pinterest",
    "YouTube",
]
xlabel = "Engagement Rate (%)"
ylabel = "Follower Growth (%)"
legend_title = "Social Media Platform"

title = "Social Media Engagement vs. Follower Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

colors = [
    "skyblue",
    "lightcoral",
    "limegreen",
    "gold",
    "orange",
    "deeppink",
    "violet",
    "cyan",
]  # Colors representing different social media platforms
markers = [
    "o",
    "^",
    "s",
    "P",
    "D",
    "X",
    "*",
    "H",
]  # Different markers for each platform

# Plot each point with corresponding color and marker
for i, (eng_rate, f_growth, color, marker) in enumerate(
    zip(engagement_rate, follower_growth, colors, markers)
):
    ax.scatter(
        eng_rate,
        f_growth,
        color=color,
        marker=marker,
        label=social_media_platforms[i],
        s=100,
        edgecolors="w",
    )

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Create legend
legend = ax.legend(
    title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left", fontsize=10
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig("scatter_71.pdf", bbox_inches="tight")
