# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting - financial data
volatility = [
    12,
    18,
    22,
    15,
    25,
    10,
    19,
    16,
]  # Stock price volatility in percentage
expected_return = [
    8,
    14,
    20,
    10,
    18,
    6,
    16,
    12,
]  # Expected return in percentage
sectors = [
    "Technology",
    "Healthcare",
    "Energy",
    "Financials",
    "Consumer Discretionary",
    "Industrials",
    "Telecommunications",
    "Utilities",
]
xlabel = "Volatility (%)"
ylabel = "Expected Return (%)"
legend_title = "Sector"
suptitle = "Stock Volatility vs. Expected Return by Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 4))

# Custom color palette
colors = [
    "#1f77b4",  # Technology - Blue
    "#ff7f0e",  # Healthcare - Orange
    "#2ca02c",  # Energy - Green
    "#d62728",  # Financials - Red
    "#9467bd",  # Consumer Discretionary - Purple
    "#8c564b",  # Industrials - Brown
    "#e377c2",  # Telecommunications - Pink
    "#7f7f7f",  # Utilities - Grey
]
markers = [
    "o",
    "s",
    "D",
    "^",
    "v",
    "<",
    ">",
    "p",
]  # Different markers for different sectors

# Plot each point with corresponding color and marker
for i, (vol, ret, color, marker) in enumerate(
    zip(volatility, expected_return, colors, markers)
):
    ax.scatter(
        vol, ret, color=color, marker=marker, label=sectors[i], edgecolor="black"
    )

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Create legend
legend = ax.legend(title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left")

# Additional style settings
ax.grid(True, linestyle="--", linewidth=0.5)
fig.suptitle(suptitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig("scatter_72.pdf", bbox_inches="tight")
