# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Data for plotting
crop_yield = [1.8, 2.5, 3.0, 2.0, 1.6, 1.5, 5.0, 3.5]  # Crop yield in tons/hectare
water_efficiency = [
    500,
    600,
    700,
    550,
    620,
    580,
    420,
    480,
]  # Water efficiency in liters/kg
crops = ["Wheat", "Rice", "Maize", "Soybean", "Barley", "Cotton", "Sugarcane", "Potato"]

xlabel = "Crop Yield (tons/hectare)"
ylabel = "Water Efficiency (liters/kg)"
legend_title = "Crop Type"
title = "Crop Yield vs. Water Efficiency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

colors = [
    "green",
    "tan",
    "gold",
    "saddlebrown",
    "darkgreen",
    "peru",
    "lightgreen",
    "orange",
]  # Colors representing different crops
markers = [
    "o",
    "v",
    "s",
    "^",
    "p",
    "*",
    "D",
    "X",
]  # Distinct markers for different crops

# Plot each point with corresponding color and marker
for i, (yield_, water, color, marker) in enumerate(
    zip(crop_yield, water_efficiency, colors, markers)
):
    ax.scatter(yield_, water, color=color, marker=marker, label=crops[i])

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Create legend
legend = ax.legend(title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig("scatter_73.pdf", bbox_inches="tight")
