# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulating geographic data for the plot
longitude = np.random.normal(0, 30, 100)
latitude = np.random.normal(0, 30, 100)
xlabel = "Longitude (°)"
ylabel = "Latitude (°)"
title = "Geographic Coordinates Scatter Plot"
annotation_text = "Sample Point"
annotation_xy = (longitude[0], latitude[0])
annotation_xytext = (longitude[0] + 10, latitude[0] + 10)
label = "Data Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
plt.figure(figsize=(10, 7))

# Scatter plot with customized colors and sizes
colors = plt.cm.viridis(np.random.rand(100))
sizes = 500 * np.random.rand(100)
scatter = plt.scatter(longitude, latitude, c=colors, s=sizes, alpha=0.6, edgecolors="w")

# Enhance the grid and background
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# Set labels, title, and annotation
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)
plt.annotate(
    annotation_text,
    xy=annotation_xy,
    xytext=annotation_xytext,
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=12,
    color="red",
)

# Add a color bar legend
cbar = plt.colorbar(scatter)
cbar.set_label(label, rotation=270, labelpad=15)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_74.pdf", bbox_inches="tight")
