# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulating data for entertainment domain
popularity_score = np.random.normal(50, 20, 100)
revenue_growth = np.random.normal(10, 15, 100)
xlabel = "Popularity Score"
ylabel = "Revenue Growth (%)"
title = "Popularity vs Revenue Growth in Entertainment"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
plt.figure(figsize=(9, 6))

cmap = "plasma"

# Scatter plot for the entertainment dataset
colors = np.random.rand(100)
sizes = 1000 * np.random.rand(100)
plt.scatter(
    popularity_score,
    revenue_growth,
    c=colors,
    s=sizes,
    alpha=0.6,
    cmap=cmap,
    marker="*",
)
plt.grid(True, linestyle="--", linewidth=0.5)

# Set labels and title for the plot
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_76.pdf", bbox_inches="tight")
