
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Group 1: Age at most influential publication vs. Number of published books
age_group1 = np.random.randint(30, 60, size=13)
books_group1 = np.random.randint(1, 20, size=13)

# Group 2: Age at most influential publication vs. Number of published books
age_group2 = np.random.randint(30, 60, size=15)
books_group2 = np.random.randint(1, 20, size=15)

legend_labels = ["Group 1", "Group 2"]
xlabel = "Age at Most Influential Publication"
ylabel = "Number of Published Books"
title = "Philosophers: Age vs. Number of Publications"
filename = "scatter_18_1.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 8))
plt.scatter(age_group1, books_group1, color='blue', marker='o', s=100, alpha=0.6, edgecolors='w', label=legend_labels[0])
plt.scatter(age_group2, books_group2, color='green', marker='s', s=100, alpha=0.6, edgecolors='w', label=legend_labels[1])
plt.grid(True)
plt.legend(legend_labels, fontsize=12)

# Adding axis labels and title
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_77.pdf", bbox_inches="tight")
