# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Week one, stock prices of Company A over 10 days:
days_week1 = np.arange(1, 11)
prices_week1 = np.random.uniform(100, 200, 10)

# Week two, stock prices of Company B over 10 days:
days_week2 = np.arange(1, 11)
prices_week2 = np.random.uniform(90, 180, 10)

# Labels and Titles
xlabel = "Days"
ylabel = "Stock Price"
title = "Stock Prices Over Two Weeks"
legend_labels = ["Company A - Week 1", "Company B - Week 2"]
labels = ["Company A - Week 1", "Company B - Week 2"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))

# Plot Week 1
plt.scatter(
    days_week1,
    prices_week1,
    color="blue",
    label=labels[0],
    marker="o",
    s=100,
    alpha=0.6,
)

# Plot Week 2
plt.scatter(
    days_week2,
    prices_week2,
    color="green",
    label=labels[1],
    marker="x",
    s=100,
    alpha=0.6,
)

# Adding grid, legend, and labels
plt.grid(True, linestyle="--", alpha=0.7)
plt.legend(loc="best")
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_78.pdf", bbox_inches="tight")
