# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the scatter plot
pages = np.random.randint(100, 1000, size=20)
ratings = np.random.uniform(3.0, 5.0, size=20)
reading_time = np.random.randint(30, 300, size=20)  # In minutes
xlabel = "Number of Pages"
ylabel = "Average Rating"
title = "Book Pages vs Rating"
colorbar_label = "Reading Time (Minutes)"
suptitle = "Literature Trend Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.scatter(
    pages, ratings, c=reading_time, cmap="plasma", s=100, edgecolor="k", alpha=0.75
)
plt.grid(True, linestyle="--", linewidth=0.5)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
cbar = plt.colorbar()
cbar.set_label(colorbar_label)
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("scatter_82.pdf", bbox_inches="tight")
