
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Generating the population data
population = np.random.randint(50000, 1000000, size=(20))
growth_rate = np.random.uniform(0.5, 5, size=(20))
city_area = np.random.uniform(50, 500, size=(20))
region_colors = np.random.randint(1, 10, size=(20))

# Text labels
title = "City Population and Growth Rate"
xlabel = "Population"
ylabel = "Growth Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(10, 8))

plt.scatter(population, growth_rate, c=region_colors, s=city_area * 10, 
            alpha=0.6, cmap="viridis", edgecolors='w', linewidth=0.5)

plt.colorbar(label="Region")
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_84.pdf", bbox_inches="tight")
