
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)
months = np.arange(1, 13)
co2_levels = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(months))) * 10 + np.random.normal(0, 1, len(months)) + 50,
    45,
    60,
)
temperature = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(months))) * 5 + np.random.normal(0, 0.5, len(months)) + 20,
    15,
    25,
)
additional_data1 = np.clip(
    np.sin(np.linspace(0, 1 * np.pi, len(months))) * 10 + np.random.normal(0, 1, len(months)) + 50,
    45,
    60,
)
additional_data2 = np.clip(
    np.cos(np.linspace(0, 1.5 * np.pi, len(months))) * 5 + np.random.normal(0, 0.5, len(months)) + 20,
    15,
    25,
)
titles = ["CO₂ Levels vs Additional Data 1", "Temperature vs Additional Data 2"]
figure1_scatter_labels = ["CO₂ Levels", "Additional Data 1"]
figure2_scatter_labels = ["Temperature", "Additional Data 2"]
xlabel = "Months"
ylabel = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# The first subplot plots CO2 levels and Additional Data 1
ax1.scatter(
    months,
    co2_levels,
    color="green",
    label=figure1_scatter_labels[0],
    marker="o",
    s=80,
    edgecolor="black",
)
ax1.scatter(
    months,
    additional_data1,
    color="darkgreen",
    label=figure1_scatter_labels[1],
    marker="s",
    s=80,
    edgecolor="black",
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="upper right")
ax1.grid(True, linestyle='--', alpha=0.6)

# The second subplot plots Temperature and Additional Data 2
ax2.scatter(
    months,
    temperature,
    color="blue",
    label=figure2_scatter_labels[0],
    marker="^",
    s=80,
    edgecolor="black",
)
ax2.scatter(
    months,
    additional_data2,
    color="darkblue",
    label=figure2_scatter_labels[1],
    marker="d",
    s=80,
    edgecolor="black",
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")
ax2.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("scatter_87.pdf", bbox_inches="tight")
