# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
companies = [
    "Company A",
    "Company B",
    "Company C",
    "Company D",
    "Company E",
    "Company F",
    "Company G",
    "Company H",
    "Company I",
]
values = {
    "Revenue Growth": [8, 6.5, 7.8, 5.2, 6.6, 4.4, 7.9, 3.1, 5.3],
    "Market Share": [15, 10, 12, 8, 14, 7.5, 16, 6, 9],
    "Customer Satisfaction": [80, 70, 75, 65, 85, 60, 90, 55, 50],
    "Innovation": [3, 2.5, 2.8, 1.2, 2.6, 1.4, 2.9, 1.1, 1.3],
    "Risk Management": [4.1, 3.7, 4.0, 3.6, 4.2, 3.5, 4.3, 2.9, 3.3],
    "Operational Efficiency": [75, 65, 70, 60, 80, 55, 85, 50, 45],
}
categorys1 = ["Revenue Growth", "Market Share"]
categorys2 = ["Customer Satisfaction", "Innovation"]
titles = ["Financial Metrics", "Performance Metrics"]
xlabel = "Score"
ylabel = "Companies"
super_title = "Comparison of Business Performance Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 7), sharey=True)
colors1 = ["#1f77b4", "#ff7f0e"]  # Sophisticated color palette
colors2 = ["#2ca02c", "#d62728"]

# Plotting for ax1 - first two categories
for category, color in zip(categorys1, colors1):
    ax1.scatter(
        values[category],
        companies,
        color=color,
        label=category,
        marker="o",
        edgecolor="k",
    )
ax1.set_title(titles[0])
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend()

# Plotting for ax2 - next two categories
for category, color in zip(categorys2, colors2):
    ax2.scatter(
        values[category],
        companies,
        color=color,
        label=category,
        marker="^",
        edgecolor="k",
    )
ax2.set_title(titles[1])
ax2.set_xlabel(xlabel)
ax2.legend()

# Common settings
for ax in [ax1, ax2]:
    ax.set_yticks(range(len(companies)))
    ax.set_yticklabels(companies)
    ax.grid(True, linestyle="--", alpha=0.6)

fig.suptitle(super_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])  # Adjust layout to fit suptitle
plt.savefig("scatter_91.pdf", bbox_inches="tight")
