
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate financial data (e.g., stock prices) for three different assets
years = np.linspace(2010, 2018, 9)
stock1 = np.cumsum(np.random.normal(loc=10, scale=2, size=9)) + 100
stock2 = np.cumsum(np.random.normal(loc=8, scale=2, size=9)) + 80
stock3 = np.cumsum(np.random.normal(loc=6, scale=2, size=9)) + 60

sizes = np.linspace(50, 150, 9)  # Define marker sizes

titles = [
    "Stock Price - Asset A",
    "Stock Price - Asset B",
    "Stock Price - Asset C",
]
xlabel = "Year"
ylabel = "Stock Price ($)"
cbar_label = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes objects
fig, axs = plt.subplots(1, 3, figsize=(15, 5))


# Define color gradients for visual appeal
colors = ["forestgreen", "mediumseagreen", "lightgreen"]

# Plot scatter plots
for ax, stock, color in zip(axs, [stock1, stock2, stock3], colors):
    sc = ax.scatter(
        years,
        stock,
        s=sizes,
        c=years,
        cmap="viridis",
        alpha=0.6,
        edgecolor="black",
    )
    ax.plot(
        years, stock, color=color, linestyle="-", linewidth=1.5, alpha=0.8
    )  # Connect points with solid lines
    ax.set_title(f"Stock Price - {color}")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_ylim(min(stock) - 10, max(stock) + 10)

# Add color bars to each subplot for color mapping explanation
for ax in axs:
    cb = plt.colorbar(sc, ax=ax, orientation="vertical")
    cb.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlapping
plt.tight_layout()

# Display the plot
plt.savefig("scatter_95.pdf", bbox_inches="tight")
