# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Prepare data
x_rec = np.array([60, 65, 70, 75, 80])  # Different data points
y_rec = np.array([20, 30, 40, 50, 60])
sizes_rec = np.random.randint(150, 350, size=len(x_rec))

x_eng = np.array([62, 67, 72, 77, 82])
y_eng = np.array([25, 35, 45, 55, 65])
sizes_eng = np.random.randint(150, 350, size=len(x_eng))

x_ret = np.array([64, 69, 74, 79, 84])
y_ret = np.array([22, 32, 42, 52, 62])
sizes_ret = np.random.randint(150, 350, size=len(x_ret))

labels = ["Recommendation (rec)", "Engagement (eng)", "Retention (ret)"]
titles = [
    "Recommendation Algorithm Performance",
    "Engagement Algorithm Performance",
    "Retention Algorithm Performance",
]
xlabel = "Precision (%)"
ylabel = "Recall (%)"
supertitle = "Social Media Algorithms Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 1 row and 3 columns
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Define a color gradient
colors = ["teal", "coral", "gold"]
markers = ["o", "s", "D"]

# Plot each dataset in a separate subplot with gradient colors
for ax, x, y, sizes, color, marker, label, title in zip(
    axs,
    [x_rec, x_eng, x_ret],
    [y_rec, y_eng, y_ret],
    [sizes_rec, sizes_eng, sizes_ret],
    colors,
    markers,
    labels,
    titles,
):
    scatter = ax.scatter(
        x,
        y,
        s=sizes,
        c=np.linspace(0.1, 1, len(x)),
        cmap="viridis",
        alpha=0.6,
        label=label,
        marker=marker,
    )
    ax.plot(x, y, linestyle="--", color=color, alpha=0.7)  # Use dashes for lines
    ax.set_title(title, fontsize=14, fontweight="bold")
    ax.set_xlabel(xlabel, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.suptitle(supertitle, fontsize=16, fontweight="bold")
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
# Show the plot
plt.savefig("scatter_98.pdf", bbox_inches="tight")
