
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Prepare data for Technology domain
x_base = np.array([2.2, 2.5, 2.8, 3.1, 3.4])  # Processor speed in GHz (base mode)
y_base = np.array([50, 55, 60, 63, 70])  # Power consumption in Watts (base mode)
sizes_base = np.random.randint(100, 300, size=len(x_base))

x_oc = np.array([3.0, 3.3, 3.6, 3.9, 4.2])  # Processor speed in GHz (overclocked mode)
y_oc = np.array([80, 90, 95, 100, 110])  # Power consumption in Watts (overclocked mode)
sizes_oc = np.random.randint(100, 300, size=len(x_oc))

x_ee = np.array([2.0, 2.3, 2.6, 2.9, 3.2])  # Processor speed in GHz (energy-efficient mode)
y_ee = np.array([40, 45, 50, 52, 55])  # Power consumption in Watts (energy-efficient mode)
sizes_ee = np.random.randint(100, 300, size=len(x_ee))

labels = ["Base Mode", "Overclocked Mode", "Energy-Efficient Mode"]
titles = ["Base Mode Performance", "Overclocked Mode Performance", "Energy-Efficient Mode Performance"]
xlabel = "Processor Speed (GHz)"
ylabel = "Power Consumption (Watts)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 1 row and 3 columns
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Define a color scheme
colors = ["steelblue", "darkorange", "forestgreen"]
markers = ["o", "s", "^"]

# Plot each dataset in a separate subplot with specified colors and markers
for ax, x, y, sizes, color, label, title, marker in zip(
    axs,
    [x_base, x_oc, x_ee],
    [y_base, y_oc, y_ee],
    [sizes_base, sizes_oc, sizes_ee],
    colors,
    labels,
    titles,
    markers,
):
    scatter = ax.scatter(
        x,
        y,
        s=sizes,
        c=np.linspace(0.1, 1, len(x)),
        cmap="winter",
        alpha=0.6,
        label=label,
        marker=marker,
        edgecolors='w'
    )
    ax.plot(x, y, linestyle="--", linewidth=1.5, color=color, alpha=0.8)  # Use dashed lines
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.tight_layout()
# Show the plot
plt.savefig("scatter_99.pdf", bbox_inches="tight")

