# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# New Data: Global Carbon Emissions (%) by Region
sizes = [27.0, 12.0, 10.0, 8.5, 7.0, 5.5, 5.0, 4.5, 4.0, 3.5, 3.0, 10.0]
labels = [
    "Asia\n27%",
    "Europe\n12%",
    "North America\n10%",
    "South America\n8.5%",
    "Africa\n7%",
    "Middle East\n5.5%",
    "Russia\n5%",
    "Australia\n4.5%",
    "Central America\n4%",
    "Southeast Asia\n3.5%",
    "South Asia\n3%",
    "Other\n10%",
]

# Text labels and colors
title = "Regional Contributions to Global Carbon Emissions (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

colors = [
    "#1b9e77",
    "#d95f02",
    "#7570b3",
    "#e7298a",
    "#66a61e",
    "#e6ab02",
    "#a6761d",
    "#666666",
    "#ff7f00",
    "#984ea3",
    "#4daf4a",
    "#f781bf",
]

# Create a treemap with custom colors and transparency
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 14, "weight": "bold"},
)

# Remove axes
plt.axis("off")

# Title Configuration
plt.title(title, fontsize=20, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_21.pdf", bbox_inches="tight")
