# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data: Average annual precipitation (in inches) for various cities
precipitation_sizes = [49.7, 47.3, 45.5, 43.7, 42.2, 40.3, 37.5, 36.2]
city_labels = [
    "New York, NY\n49.7 in",
    "Houston, TX\n47.3 in",
    "Chicago, IL\n45.5 in",
    "Atlanta, GA\n43.7 in",
    "Seattle, WA\n42.2 in",
    "San Francisco, CA\n40.3 in",
    "Miami, FL\n37.5 in",
    "Denver, CO\n36.2 in",
]

title = "Average Annual Precipitation in Various US Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Color scheme for precipitation
precipitation_colors = [
    "#c7e9b4",
    "#7fcdbb",
    "#41b6c4",
    "#1d91c0",
    "#225ea8",
    "#253494",
    "#081d58",
    "#4d004b",
]


# Create a treemap
squarify.plot(
    sizes=precipitation_sizes,
    label=city_labels,
    color=precipitation_colors,
    alpha=0.8,
    text_kwargs={"fontsize": 15, "weight": "bold"},
)

# Remove axes
plt.axis("off")

# Add a title to the plot
plt.title(title, fontsize=20)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_22.pdf", bbox_inches="tight")
