# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.30, 0.20, 0.15, 0.25, 0.05, 0.05]
labels = [
    "Netflix\n30%",
    "Amazon Prime\n20%",
    "Hulu\n15%",
    "Disney+\n25%",
    "HBO Max\n5%",
    "Other\n5%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Text label parameters
text_kwargs = {"fontsize": 18, "color": "white"}

# Colors based on the entertainment theme
colors = ["#ff6347", "#ffa07a", "#20b2aa", "#add8e6", "#778899", "#8a2be2"]


# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs=text_kwargs,
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_26.pdf", bbox_inches="tight")
