# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [40, 30, 10, 10, 5, 5]
labels = [
    "Stocks 40%",
    "Bonds 30%",
    "Real Estate 10%",
    "Cash 10%",
    "Commodities 5%",
    "Cryptocurrencies 5%",
]

# Text labels
title = "Investment Portfolio Allocation"
supertitle = "Financial Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728", "#9467bd", "#8c564b"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "black"},
    ec="white",
)

# Remove axes
plt.axis("off")

# Add titles
plt.title(title, fontsize=18, fontweight="bold")
plt.suptitle(supertitle, fontsize=20, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_30.pdf", bbox_inches="tight")
