# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for tourism expenditures in different categories
sizes = [40, 30, 15, 8, 5, 2]
labels = [
    "Accommodation 40%",
    "Transportation 30%",
    "Food & Drink 15%",
    "Entertainment 8%",
    "Shopping 5%",
    "Other 2%",
]

# Title and figure size
title = "Tourism Expenditure Distribution"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size

# Color palette
# Chart text properties
text_properties = {"fontsize": 14, "fontweight": "bold", "color": "white"}

colors = ["#377eb8", "#4daf4a", "#e41a1c", "#ff7f00", "#984ea3", "#ffff33"]
fig = plt.figure(figsize=(8, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs=text_properties,
    ec="white",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=16, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_32.pdf", bbox_inches="tight")
