
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30, 25, 20, 15, 10, 18]  # Example sizes representing market share/popularity
labels = [
    "Movies\n30%",
    "Music\n25%",
    "Video Games\n20%",
    "Books\n15%",
    "TV Shows\n10%",
    "Streaming\n18%",
]
title = "Entertainment Industry Market Share"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 8))

# Define custom colors
colors = ["#FF6347", "#FFD700", "#8A2BE2", "#3CB371", "#1E90FF", "#FF69B4"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "white"},
    pad=True,
    ec="black",
)

# Set title
plt.title(title, fontsize=20, fontweight="bold")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_33.pdf", bbox_inches="tight")

# Show the plot
