# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30, 25, 20, 10, 8, 7]
labels = [
    "Fiction\n30%",
    "Non-Fiction\n25%",
    "Mystery\n20%",
    "Fantasy\n10%",
    "Science Fiction\n8%",
    "Romance\n7%",
]
# Text label parameters
title = "Distribution of Book Genres"
suptitle = "Literary Genre Popularity"
xlabel = "Genres"
ylabel = "Percentage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
# Colors: Pastel hues
colors = ["#FFB6C1", "#ADD8E6", "#98FB98", "#FFDAB9", "#E6E6FA", "#FFFACD"]

fig = plt.figure(figsize=(8, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title and suptitle
plt.suptitle(suptitle, fontsize=20, fontweight="bold")
plt.title(title, fontsize=16, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_34.pdf", bbox_inches="tight")
