# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [25.0, 23.0, 19.0, 14.0, 10.0, 5.0, 4.0]
labels = [
    "Energy\n25.0%",
    "Industry\n23.0%",
    "Transport\n19.0%",
    "Agriculture\n14.0%",
    "Residential\n10.0%",
    "Waste\n5.0%",
    "Other\n4.0%",
]

# Text labels
title_text = "Global Greenhouse Gas Emissions by Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Colors reflecting environmental themes
colors = [
    "#2c7bb6",
    "#abd9e9",
    "#ffffbf",
    "#fee08b",
    "#fdae61",
    "#d73027",
    "#1a9850",
]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 18, "weight": "bold"},
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title_text, fontsize=22, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_38.pdf", bbox_inches="tight")
