
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data representing percentage of time spent on different platforms for political engagement
sizes = [30.00, 25.00, 18.00, 10.00, 8.00, 5.00, 2.00, 2.00]
labels = [
    "Facebook\n30.00%",
    "Twitter\n25.00%",
    "YouTube\n18.00%",
    "Reddit\n10.00%",
    "Instagram\n8.00%",
    "LinkedIn\n5.00%",
    "Snapchat\n2.00%",
    "Other\n2.00%",
]

# Chart title and annotations (put in part 2 as required)
title = "Time Spent on Social Media Platforms for Political Engagement"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f78b4",  # Facebook
    "#a6cee3",  # Twitter
    "#b2df8a",  # YouTube
    "#33a02c",  # Reddit
    "#fb9a99",  # Instagram
    "#e31a1c",  # LinkedIn
    "#fdbf6f",  # Snapchat
    "#cab2d6",  # Other
]

# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Set title
plt.title(title, fontsize=22)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_39.pdf", bbox_inches="tight")
