
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [31, 24, 16, 15, 7, 7]
labels = [
    "Christianity\n31%",
    "Islam\n24%",
    "Irreligious\n16%",
    "Hinduism\n15%",
    "Buddhism\n7%",
    "Other\n7%",
]

# Text labels and title
title = "Global Distribution of Major Religions"
suptitle = "Representation of Major Religions by Percentage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3", "#fdb462"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "black"},
    pad=0.3,
)

# Add title and supertitle
plt.title(title, fontsize=24)
plt.suptitle(suptitle, fontsize=18, y=0.95)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save plot
plt.savefig("tree_45.pdf", bbox_inches="tight")
