
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30.3, 22.1, 15.2, 12.5, 10.7, 6.5, 2.7]
labels = [
    "Apple\n30.3%",
    "Samsung\n22.1%",
    "Google\n15.2%",
    "Microsoft\n12.5%",
    "Amazon\n10.7%",
    "Facebook\n6.5%",
    "Others\n2.7%",
]

title = 'Tech Companies Market Share'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Modern color palette
colors = ["#3366cc", "#dc3912", "#ff9900", "#109618", "#990099", "#3b3eac", "#0099c6"]

# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold", "color": "white"},
    ec="white",
)

# Add title
plt.title(title, fontsize=22, weight="bold", color="gray")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_54.pdf", bbox_inches="tight")
