
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [1441, 1393, 331, 273, 221, 212, 166]  # Populations in millions for countries
total_size = sum(sizes)
percentages = [size / total_size * 100 for size in sizes]
labels = [
    f"China\n{percentages[0]:.1f}%",
    f"India\n{percentages[1]:.1f}%",
    f"USA\n{percentages[2]:.1f}%",
    f"Indonesia\n{percentages[3]:.1f}%",
    f"Pakistan\n{percentages[4]:.1f}%",
    f"Brazil\n{percentages[5]:.1f}%",
    f"Nigeria\n{percentages[6]:.1f}%",
]

title = 'Most Populous Countries'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3", "#fdb462", "#b3de69"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="white",
)

# Add title
plt.title(title, fontsize=22)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_56.pdf", bbox_inches="tight")
