# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [52.5, 16.8, 11.5, 9.8, 7.9, 1.5]
labels = [
    "Asia\n52.5%",
    "Europe\n16.8%",
    "Africa\n11.5%",
    "Latin America\n9.8%",
    "North America\n7.9%",
    "Oceania\n1.5%",
]
title = "Global Internet Usage by Continent"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854", "#ffd92f"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=22, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_58.pdf", bbox_inches="tight")
