
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [30, 25, 20, 15, 7, 3]
labels = [
    "Coal\n30%",
    "Oil\n25%",
    "Natural Gas\n20%",
    "Deforestation\n15%",
    "Industrial Processes\n7%",
    "Waste\n3%",
]
title = 'Global Carbon Emissions by Source'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
colors = ["#2E8B57", "#556B2F", "#66CDAA", "#8FBC8F", "#3CB371", "#20B2AA"]
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_62.pdf", bbox_inches="tight")
