
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data - Transportation Categories
sizes = [35, 25, 20, 10, 5, 5]
labels = [
    "Cars - 35%", 
    "Buses - 25%", 
    "Bicycles - 20%", 
    "Trains - 10%", 
    "Boats - 5%", 
    "Airplanes - 5%"
]
title = "Transportation Categories Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#3498DB", "#E74C3C", "#2ECC71", "#8E44AD", "#F1C40F", "#95A5A6"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "black"},
    edgecolor="white",  # Improved border visibility
    linewidth=2  # Added edge line width for better visuals
)

# Set plot title
plt.title(title, fontsize=18, color='black', weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_63.pdf", bbox_inches="tight")
