
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [40, 25, 15, 10, 6, 4]
labels = ["Soccer", "Basketball", "Baseball", "Tennis", "Golf", "Rugby"]
title = "Sports Popularity Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1F77B4", "#FF7F0E", "#2CA02C", "#D62728", "#9467BD", "#8C564B"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.75,
    text_kwargs={"fontsize": 12, "color": "white"},
    ec="white",  # edge color
)

# Add title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_66.pdf", bbox_inches="tight")
