# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [35, 20, 18, 12, 10, 5]
labels = [
    "Baker & McKenzie\n35%",
    "Skadden\n20%",
    "Clifford Chance\n18%",
    "Latham & Watkins\n12%",
    "Allen & Overy\n10%",
    "Others\n5%",
]
title = "Market Share of Global Law Firms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#2E86C1", "#A569BD", "#45B39D", "#F4D03F", "#E74C3C", "#5D6D7E"]
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.9,
    text_kwargs={"fontsize": 12, "color": "white"},
    ec="white",
)

# Set the title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_69.pdf", bbox_inches="tight")
