
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30, 20, 15, 15, 10, 10]
labels = [
    "Technology\n30%",
    "Healthcare\n20%",
    "Consumer Goods\n15%",
    "Finance\n15%",
    "Energy\n10%",
    "Utilities\n10%"
]
title = "Market Share by Economic Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
# Create a figure with the specified size
fig = plt.figure(figsize=(6, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 14, "color": "white"},
    ec="white",
)

# Set the title
plt.title(title, fontsize=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_71.pdf", bbox_inches="tight")
