# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================

# Data
sizes = [35, 30, 20, 10, 5]
labels = ["Plato\n35%", "Aristotle\n30%", "Kant\n20%", "Nietzsche\n10%", "Socrates\n5%"]
title = "Influence of Philosophical Schools"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Text label parameters
text_kwargs = {"fontsize": 14, "color": "black", "weight": "bold"}

colors = ["#87CEEB", "#DDA0DD", "#FFB6C1", "#8A2BE2", "#98FB98"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs=text_kwargs,
    pad=True,
    ec="white",
)

# Set title
plt.title(title, fontsize=20, weight="bold", pad=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_74.pdf", bbox_inches="tight")
