# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [200, 150, 130, 100, 90, 80, 70, 50]  # Number of seats for each party
labels = [
    "Party A\n200 seats",
    "Party B\n150 seats",
    "Party C\n130 seats",
    "Party D\n100 seats",
    "Party E\n90 seats",
    "Party F\n80 seats",
    "Party G\n70 seats",
    "Party H\n50 seats",
]
title = "Distribution of Seats in the Parliament"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
    "#8c564b",
    "#e377c2",
    "#7f7f7f",
]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 12, "color": "black"},
    pad=True,
    ec="white",
)

# Add a title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_75.pdf", bbox_inches="tight")
