
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [25, 20, 15, 18, 12, 10]  # Representing the proportion of each sector
labels = [
    "Technology\n25%",
    "Healthcare\n20%",
    "Finance\n15%",
    "Consumer Discretionary\n18%",
    "Industrials\n12%",
    "Utilities\n10%",
]
title = "Market Share of S&P 500 Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#3366cc", "#dc3912", "#ff9900", "#109618", "#990099", "#0099c6"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 14, "color": "white"},
    pad=True,
    ec="white",
)

# Add a title
plt.title(title, fontsize=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_76.pdf", bbox_inches="tight")
